package w83b.w83bDAO;

import java.util.ArrayList;
import java.util.List;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bBeans.W83bActasBean;
import w83b.w83bBeans.W83bDelegadosBean;
import w83b.w83bDAO.w83bConstantesBD.W83bDelegadosBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bDateUtil;


public class W83bDelegadosDAO implements W83bIDelegadosDAO {
	
	/**
	 * Obtiene un delegado  de un acta
	 * @param acta W83bActasBean
	 * @param dniDelegado String
	 * @return W83bDelegadosBean
	 * @throws Exception exception
	 */
	public W83bDelegadosBean obtenerDelegadoActa(W83bActasBean acta, String dniDelegado) throws Exception {
		
		StringBuffer strSql = new StringBuffer(W83bClsConstantes.CUARENTA);
		List params = new ArrayList();
		
		strSql.append("SELECT ");
		strSql.append(W83bDelegadosBD.dni).append(",");
		strSql.append(W83bDelegadosBD.baja).append(",");
		strSql.append(W83bDelegadosBD.acta).append(",");
		strSql.append(W83bDelegadosBD.anyoActa).append(",");
		strSql.append(W83bDelegadosBD.territorioActa).append(",");
		strSql.append(W83bDelegadosBD.versionActa).append(",");
		strSql.append("to_char(").append(W83bDelegadosBD.fechaBaja).append(",?) AS ").append(W83bDelegadosBD.fechaBaja).append(",");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		strSql.append(W83bDelegadosBD.codSindicato).append(",");
		strSql.append(W83bDelegadosBD.codColegio).append(",");
		strSql.append(W83bDelegadosBD.nombre).append(",");
		strSql.append(W83bDelegadosBD.apellido1).append(",");
		strSql.append(W83bDelegadosBD.apellido2).append(",");
		strSql.append(W83bDelegadosBD.sexo).append(",");
		strSql.append("to_char(").append(W83bDelegadosBD.fechaAlta).append(",?) AS ").append(W83bDelegadosBD.fechaAlta).append(",");
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		strSql.append(W83bDelegadosBD.dniSustituto).append(",");
		strSql.append(W83bDelegadosBD.usuario).append(",");
		strSql.append("to_char(").append(W83bDelegadosBD.fechaMod).append(",?) AS ").append(W83bDelegadosBD.fechaMod);
		params.add(W83bDateUtil.getInstance().devolverFormatoIdioma(acta.getIdioma()));
		
		strSql.append(" FROM ").append(W83bDelegadosBD.delegadosVista);
		strSql.append(" WHERE ").append(W83bDelegadosBD.territorioActa).append(" = ?");
		strSql.append(" AND ").append(W83bDelegadosBD.acta).append(" = ?");
		strSql.append(" AND ").append(W83bDelegadosBD.anyoActa).append(" = ?");
		strSql.append(" AND ").append(W83bDelegadosBD.versionActa).append(" = ?");
		strSql.append(" AND ").append(W83bDelegadosBD.dni).append(" = ?");
		params.add(acta.getNumActaTerritorio());	
		params.add(acta.getNumActa());
		params.add(acta.getNumActaAno());
		params.add(acta.getVersion());
		params.add(dniDelegado);

		
		
		List delegados = W83bDataBase.executeQuery(strSql.toString(),params,W83bDelegadosBean.class,null, "delegado");
		
		if (delegados.size()>0)
			return (W83bDelegadosBean)delegados.get(0);
		else
			return null;
	}

	
}
